<?php
/**
 * functions in this file...
 *
 * query - Ställer en fråga till databasen
 * new_game - retunerar ett nytt tomt bärde
 * get_game_state - hämtar status på ett bräde från databasen
 * fork - kollar om ett move är en fork
 * win - kollar om ett move ger en vinst
 * check_if_can_win - testar alla drag för att kolla om det finns någto som ger vinst
 * check_if_can_fork - testar alla drag för att kolla om det finns någto som ger en fork
 * check_if_can_press - testar alla drag för att kolla om det finns någto som ger en press
 * can_move - kollar om move är ett giltigt drag
 * move - utför ett drag
 * random_move - slumpar ett ok giltigt move
 * level_move - gör ett så bra drag som möjligt
 * corner - lägger i ett hörn
 * print_board - skriver ut bordet (debug)
 * print_result - skriver ut bordet och hur det gick (debug)
 *
 */


/**
 * @param $query
 * @return bool|\mysqli_result
 */
function query($query) {
  global $link;
  if ($result = mysqli_query($link, $query)) {
    return $result;
  }
  else {
    set_message("Error in SQL-statement " . $query . mysqli_error($link), 'danger');
    return FALSE;
  }
}


/**
 * Hoppar ur och skriver ut jsondata (ev debug info).
 * @param $game
 */
function exit_game($game) {
  header('Content-Type: application/json');
  if (FALSE) {
    print_board($game);
  }
  echo json_encode($game);
  exit;
}
