/**
 * Tests the class Clock.
 * 
 * @author Daniel
 * 2011-04-16
 */
public class ClockTester {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		//Tests that a new clock 00:00 is created.
		Clock cl=new Clock();
		System.out.println(cl.getTime());
		System.out.println("Expected: 00:00");
		System.out.println();
		
		// Tests that the clock can tick two times.
		cl.timeTick();
		cl.timeTick();
		System.out.println(cl.getTime());
		System.out.println("Expected: 00:02");
		System.out.println();
		
		// Tests the setTime method.
		cl.setTime(22,59);
		System.out.println(cl.getTime());
		System.out.println("Expected: 22:59");
		System.out.println();
		
		// Tests that the minutes wraps around and can continue to tick.
		cl.timeTick();
		System.out.println(cl.getTime());
		cl.timeTick();
		System.out.println(cl.getTime());
		System.out.println("Expected: 23:00");
		System.out.println("Expected: 23:01");
		System.out.println();
		
		// Tests that the hours wraps around and can continue to tick.
		cl.setTime(23,59);
		cl.timeTick();
		System.out.println(cl.getTime());
		cl.timeTick();
		System.out.println(cl.getTime());
		System.out.println("Expected: 00:00");
		System.out.println("Expected: 00:01");
		System.out.println();
		
		// Tests exception if minute is set out of range and if hour is set out of range.
		try{
			cl.setTime(-10, 8);
		}
		catch(IllegalArgumentException e){
			System.out.println(e.getMessage());
		}
		try{
			cl.setTime(12,60);
		}
		catch(IllegalArgumentException e){
			System.out.println(e.getMessage());
		}
		System.out.println("Expected: Value out of range in display");
		System.out.println("Expected: Value out of range in display");
		System.out.println();
		
		// Tests constructor with parameters.
		Clock cl2=new Clock(11,9);
		System.out.println(cl2.getTime());
		System.out.println("Expected: 11:09");
		System.out.println();
		
		// Tests constructor with illegal parameters that generates an exception.
		try{
			Clock cl3=new Clock(25,9);
			System.out.println(cl3.getTime());
		}
		catch(IllegalArgumentException e){
			System.out.println(e.getMessage());
		}
		System.out.println("Expected: Value out of range in display");
		System.out.println();
	}
}
