<?php

/**
 * @file
 * Functions in this file...
 */

/**
 * Send all querys to this function.
 *
 * @param string $query
 *   Query-string.
 *
 * @return bool|\mysqli_result
 *   Return mysqli_result or FALSE if error.
 */
function query($query) {
  global $link;
  if ($result = mysqli_query($link, $query)) {
    return $result;
  }
  elseif (DEBUG_STATUS) {
    $data = [
      'status_code' => 400,
      'error' => mysqli_error($link),
      'query' => $query,
    ];
    quiz_response($data);
  }
  else {
    $data = [
      'status_code' => 400,
    ];
    quiz_response($data);
  }
}

/**
 * Validate token.
 *
 *   Exit if token is invalid.
 */
function authorize() {
  if (!isset($_POST['auth_token'])) {
    $data = [
      'status_code' => 400,
    ];
    quiz_response($data);
  }
  $query = "SELECT * FROM `users` WHERE `token` = '" . $_POST['auth_token'] . "' AND DATE_ADD(`token_datetime`, INTERVAL " . TOKEN_LIFE . " DAY) > NOW()";
  $result = query($query);
  if (mysqli_num_rows($result) != 1) {
    $data = [
      'status_code' => 401,
    ];
    quiz_response($data);
  }
  $row = mysqli_fetch_assoc($result);
  return $row['id'];
}

/**
 * Hoppar ur och skriver ut jsondata (ev debug info).
 *
 * @param array $data
 *   PHP-array.
 */
function quiz_response(array $data = []) {
  if (empty($data['status_code'])) {
    $data = [
      'status_code' => 404,
      'status_message' => 'Not Found',
    ];
  }
  header_status($data['status_code']);
  header('Content-Type: application/json');
  echo json_encode($data);
  exit;
}

/**
 * Send header with statuscode.
 *
 * @param int $status_code
 *   Statuscode.
 */
function header_status($status_code) {
  static $status_codes = NULL;

  if ($status_codes === NULL) {
    $status_codes = [
      100 => 'Continue',
      101 => 'Switching Protocols',
      102 => 'Processing',
      200 => 'OK',
      201 => 'Created',
      202 => 'Accepted',
      203 => 'Non-Authoritative Information',
      204 => 'No Content',
      205 => 'Reset Content',
      206 => 'Partial Content',
      207 => 'Multi-Status',
      300 => 'Multiple Choices',
      301 => 'Moved Permanently',
      302 => 'Found',
      303 => 'See Other',
      304 => 'Not Modified',
      305 => 'Use Proxy',
      307 => 'Temporary Redirect',
      400 => 'Bad Request',
      401 => 'Unauthorized',
      402 => 'Payment Required',
      403 => 'Forbidden',
      404 => 'Not Found',
      405 => 'Method Not Allowed',
      406 => 'Not Acceptable',
      407 => 'Proxy Authentication Required',
      408 => 'Request Timeout',
      409 => 'Conflict',
      410 => 'Gone',
      411 => 'Length Required',
      412 => 'Precondition Failed',
      413 => 'Request Entity Too Large',
      414 => 'Request-URI Too Long',
      415 => 'Unsupported Media Type',
      416 => 'Requested Range Not Satisfiable',
      417 => 'Expectation Failed',
      422 => 'Unprocessable Entity',
      423 => 'Locked',
      424 => 'Failed Dependency',
      426 => 'Upgrade Required',
      500 => 'Internal Server Error',
      501 => 'Not Implemented',
      502 => 'Bad Gateway',
      503 => 'Service Unavailable',
      504 => 'Gateway Timeout',
      505 => 'HTTP Version Not Supported',
      506 => 'Variant Also Negotiates',
      507 => 'Insufficient Storage',
      509 => 'Bandwidth Limit Exceeded',
      510 => 'Not Extended',
    ];
  }

  if (!empty($status_codes[$status_code])) {
    $status_string = $status_code . ' ' . $status_codes[$status_code];
    header($_SERVER['SERVER_PROTOCOL'] . ' ' . $status_string, TRUE, $status_code);
  }
}
