<?php
$path = '../';
include($path.'include/setup.php');

// autoload funktion för att ladda rätt klass
function __autoload($class) {
	$arr = explode('_',$class);
	require_once('../classes/'.$arr[0].'/'.$arr[1].'.php'); 
}

// Lite init variabler
$self = basename($_SERVER['SCRIPT_NAME']);
$session = new service_session('jf');
$db = new service_db($settings);


// i dessa lägger man data
$data = array();
$row = false;

// Säkrar upp vad som kommer i $_GET['c'] c=controller och i $_GET['a'] a=action, kommer inget blir det index
(isset($_GET['c'])?str_replace('.','',$_GET['c']):$_GET['c'] = 'index');
(isset($_GET['a'])?str_replace('.','',$_GET['a']):$_GET['a'] = 'index');

// läser in rätt controller
$controller = $path . 'controllers/' . $_GET['c'] . 'Controller.php';
if (file_exists($controller)) {
	include($controller);
} else {
	$session->AddError('No controller named:' . $_GET['c'] . 'Controller');
}

// visar HTML med rätt view
include($path.'views/head.php');
$session->PrintInfo();; // skriver ut fel och annan info
$view = $path . 'views/' . $_GET['c'] . '/' . $_GET['a'] . '.php';
if (file_exists($view)) {
	include($view);
} else {
	$session->AddError('No view in ' . $_GET['c']. ' named:' . $_GET['a']);
	$session->PrintInfo();; // Man vill ju se detta fel också...
}
include($path.'views/foot.php');
