<?php
/**
 * Klass för att hantera sessioner...
 * $_SESSION[$section][$key] om $key anges, annars $_SESSION[$section]
 *
 * @author jf
 */

class service_session {

	public function __construct($name) {
		session_name($name);
		session_start();
	}

	public function Destroy() {
		session_destroy();
	}

	/**
	 * Behöver ett sätt att kommunicera med användarna
	 * @param $message
	 */
	public function AddError($message) {
		$_SESSION['Errors'][] = $message;
	}

	/**
	 * Behöver ett sätt att kommunicera med användarna
	 * @param $message
	 */
	public function AddSuccess($message) {
		$_SESSION['Success'][] = $message;
	}

	/**
	 * Skriver ut alla Errors och alla Success, tömmer sedan dessa variabler
	 */
	public function PrintInfo() {
		// Skriver ut alla errors om det finns några
		if (count($_SESSION['Errors'])) {
			echo '<div class="error">ERROR<br>';
			foreach($_SESSION['Errors'] as $error) {
				echo $error . '<br>';
			}
			echo '</div>';
			unset($_SESSION['Errors']);
		}
		// Skriver ut info om det finns någon
		if (count($_SESSION['Success'])) {
			echo '<div class="success">SUCCESS<br>';
			foreach($_SESSION['Success'] as $success) {
				echo $success . '<br>';
			}
			echo '</div>';
			unset($_SESSION['Success']);
		}
	}

	public function CheckLogin() {
		if(!$this->Get('UserID')) {
			header ('location: index.php?c=login&a=login');
			exit();
		}
		return true;
	}

	public function Set($value, $section, $key = '') {
		if (empty($key)) {
			$_SESSION[$section] = $value;
		} else {
			if ($key == 'ai') {
				$_SESSION[$section][count($_SESSION[$section])] = $value;
			} else {
				$_SESSION[$section][$key] = $value;
			}
		}
	}

	public function Get($section, $key = '') {
		if (empty($key) && isset($_SESSION[$section])) {
			return $_SESSION[$section];
		} elseif (!empty($key) && isset($_SESSION[$section][$key])) {
			return $_SESSION[$section][$key];
		}
		return false;
	}

	public function Delete($section, $key = '') {
		if (empty($key) && isset($_SESSION[$section])) {
			unset($_SESSION[$section]);
			return true;
		} elseif (!empty($key) && isset($_SESSION[$section][$key])) {
			unset($_SESSION[$section][$key]);
			return true;
		}
		return false;
	}
}
